------------------------------------------------------------------------------
--                   IMPORTANT:  DO NOT EDIT THIS FILE!!!                   --
------------------------------------------------------------------------------
-- This file relies on other versions of itself being the same.             --
-- If you need something in this file changed, please let the creator know! --
------------------------------------------------------------------------------

-------------
-- version --
-------------

local fileVersion = 1

--prevent older/same version versions of this script from loading
if ScreenHelper and ScreenHelper.Version >= fileVersion then
  return ScreenHelper
end

if not ScreenHelper then
  ScreenHelper = {}
  ScreenHelper.Version = fileVersion
elseif ScreenHelper.Version < fileVersion then
  local oldVersion = ScreenHelper.Version

  -- handle old versions

  ScreenHelper.Version = fileVersion
end

---------------------
--hud offset helper--
---------------------

ScreenHelper.CurrentScreenOffset = ScreenHelper.CurrentScreenOffset or 0

function ScreenHelper.SetOffset(num)
  num = math.min(math.max(math.floor(num), 0), 10)

  ScreenHelper.CurrentScreenOffset = num

  return num
end

function ScreenHelper.GetOffset()
  return ScreenHelper.CurrentScreenOffset
end

------------------------------------
--screen size and corner functions--
------------------------------------

local vecZero = Vector(0, 0)
function ScreenHelper.GetScreenSize()
  if REPENTANCE then
    local screenWidth = Isaac.GetScreenWidth()
    local screenHeight = Isaac.GetScreenHeight()

    return Vector(screenWidth, screenHeight)
  else --based off of code from kilburn
    local game = Game()
    local room = game:GetRoom()

    local pos = room:WorldToScreenPosition(vecZero) - room:GetRenderScrollOffset() - game.ScreenShakeOffset

    local rx = pos.X + 60 * 26 / 40
    local ry = pos.Y + 140 * (26 / 40)

    return Vector(rx * 2 + 13 * 26, ry * 2 + 7 * 26)
  end
end

function ScreenHelper.GetScreenCenter()
  return ScreenHelper.GetScreenSize() / 2
end

function ScreenHelper.GetScreenBottomRight(offset)
  offset = offset or ScreenHelper.GetOffset()

  local pos = ScreenHelper.GetScreenSize()
  local hudOffset = Vector(-offset * 2.2, -offset * 1.6)
  pos = pos + hudOffset

  return pos
end

function ScreenHelper.GetScreenBottomLeft(offset)
  offset = offset or ScreenHelper.GetOffset()

  local pos = Vector(0, ScreenHelper.GetScreenBottomRight(0).Y)
  local hudOffset = Vector(offset * 2.2, -offset * 1.6)
  pos = pos + hudOffset

  return pos
end

function ScreenHelper.GetScreenTopRight(offset)
  offset = offset or ScreenHelper.GetOffset()

  local pos = Vector(ScreenHelper.GetScreenBottomRight(0).X, 0)
  local hudOffset = Vector(-offset * 2.2, offset * 1.2)
  pos = pos + hudOffset

  return pos
end

function ScreenHelper.GetScreenTopLeft(offset)
  offset = offset or ScreenHelper.GetOffset()

  local pos = vecZero
  local hudOffset = Vector(offset * 2, offset * 1.2)
  pos = pos + hudOffset

  return pos
end

return ScreenHelper
